<?php
define( 'DB_RESET_VERSION', '3.0.2' );
define( 'DB_RESET_PATH', dirname( __FILE__ ) );
define( 'DB_RESET_NAME', basename( DB_RESET_PATH ) );
define( 'AUTOLOADER', DB_RESET_PATH . '/lib/class-plugin-autoloader.php' );

require_once( DB_RESET_PATH . '/lib/helpers.php' );

register_activation_hook( __FILE__, 'db_reset_activate' );

// load_plugin_textdomain( 'wordpress-database-reset', false, DB_RESET_NAME . '/languages/' );

if ( file_exists( AUTOLOADER ) ) {
  require_once( AUTOLOADER );
  new Plugin_Autoloader( DB_RESET_PATH );

  add_action(
    'wp_loaded',
    array ( new DB_Reset_Manager( DB_RESET_VERSION ), 'run' )
  );
}



    function wpfreshstart_tab2() {
        global $wpdb;
        $wp_tables = $wpdb->tables();
?>
  <form method="post" id="db-reset-form" CLASS="form">
<BR/>

  <div class="panel panel-default">
    <div class="panel-heading"><h3 class="freshtart-headline panel-title"><i class="fa fa-refresh"></i> InstaReset</h3></div>
    <div class="panel-body">

    <p>InstaReset will completely reset up your wordpress site database tables to their original state.</p>

<p>This means all your data will be wiped out. Among all the users, just the admin user will remain.</p>

<p>Themes and plugins will remain but will be marked inactive, to customize settings use the Advanced option. </p>
    <a class="btn btn-info btn-xs" role="button" data-toggle="collapse" href="#advanced_instareset" aria-expanded="false" aria-controls="advanced_instareset">
      <i class="fa fa-cog"></i> Advanced
    </a>
<br/>
<br/>
    <div class="collapse" id="advanced_instareset"><div class="well">
<h4><?php _e( 'Select the database tables you would like to reset', 'wordpress-database-reset' ) ?>:</h4>

<div id="select-container">
  <a href='#' id="select-all"><?php _e( 'Select All', 'wordpress-database-reset' ) ?></a>
  <select id="wp-tables" multiple="multiple" name="db-reset-tables[]">
    <?php foreach ( $wp_tables as $key => $value ) : ?>
      <option value="<?php echo $key ?>" selected="selected"><?php echo $key ?></option>
    <?php endforeach ?>
  </select>
</div>

<p id="reactivate">
  <label for="db-reset-reactivate-theme-data">
    <input type="checkbox" name="db-reset-reactivate-theme-data" id="db-reset-reactivate-theme-data" value="true" />
    <?php _e( 'Reactivate current theme and plugins after reset?', 'wordpress-database-reset' ) ?>
  </label>
</p>
</div>
</div>
<p>
    <h4>Write "CONFIRM" here:</h4>
    <input type="text" name="db-reset-code-confirm" id="db-reset-code-confirm">
</p>
<p>
  <!-- <input type="submit" name="db-reset-submit" value="<?php _e( 'Reset Tables', 'wordpress-database-reset' ) ?>" id="db-reset-submit" class='click-start-submit' disabled /> -->
  <button type="submit" name="db-reset-submit" value="<?php _e( 'Reset Tables', 'wordpress-database-reset' ) ?>" id="db-reset-submit" class='btn btn-primary' disabled /><i class="fa fa-check"></i> Run!</button>
  

  <img src="<?php echo WPFRESHSTART_URL.'/instareset/assets/images/spinner.gif'; ?>" alt="loader" id="loader" style="display: none" />

  <div class="alert alert-danger">
                  <i class="fa fa-warning"></i> <b>WARNING!</b> By clicking "Run" button, all data from the database will be deleted
              </div>
</p>
</form>
</div></div>
<?php
    }


?>