<?php
/*
Plugin Name: WP Freshstart 3
Version: 3.1
Plugin URI: http://wp-freshstart.com
Description: This 1-Click Plugin does all the menial wordpress tasks needed to setup a brand new site. Also can instantly RESET an existing site back to a freshly setup wordpress.
Author: Ankur Shukla
*/
ob_start();
define( 'STORE_URL', 'http://wp-freshhstart.com' );
define( 'ITEM_NAME', 'WP Freshstart' );
define ('WP_FRESH_START_URL',plugin_dir_url( __FILE__ ));
define('SITE_NAME', get_bloginfo('name'));

define( 'WPFRESHSTART_VERSION', '1.56' );
define( 'WPFRESHSTART_PLUGIN_NAME', dirname(plugin_basename(__FILE__) ));
define( 'WPFRESHSTART_DIR', plugin_dir_path( __FILE__ ) );
define( 'WPFRESHSTART_URL', plugins_url( WPFRESHSTART_PLUGIN_NAME ) );

require 'instareset/insta-reset.php';

/* Automatic Updates */
require 'plugin-update-checker.php';
$wpbeautify_update_checker = new PluginUpdateChecker_2_3(
    'http://wpfreshstart.s3.amazonaws.com/plugin-updates/1-std/info_freshstart.json',
    __FILE__
);


add_action( 'init', 'wpfreshstart_add_footer_pages' );//adding footer menu when its active
add_action( 'admin_init', 'wpfreshstart_options_data' );//save data to db for storing page list to add on footer
add_action( 'admin_menu', 'wp_wpfreshstart_menu' );
add_action( 'admin_init', 'wpfreshstart_js');
add_action('admin_head', 'wpfreshstart_styles');//adding plugin style for admin

function wpfreshstart_add_footer_pages(){
    $footer_pages = get_option('wpfreshstart_auto_pages_show_names');
    if(!empty($footer_pages)){
        // add_action('wp_footer', 'wpfreshstart_show_footer_pages');
        add_action( 'wp_enqueue_scripts', 'wpfreshstart_front_js' );
    }
}
function wpfreshstart_show_footer_pages(){
    $footer_pages = get_option('wpfreshstart_auto_pages_show_names');
    $all_wpfreshstart_created_pages = explode(",", $footer_pages);
   ?>
   <ul class="nav-menu wp-wpfreshstart-nav-menu">
       <?php foreach ($all_wpfreshstart_created_pages as $all_wpfreshstart_created_page){
        echo '<li>'.'<a href="'.get_permalink( get_page_by_title( $all_wpfreshstart_created_page ) ).'">'.$all_wpfreshstart_created_page.'</a></li>';

    }
    ?>
   </ul>


    <?php
}
function wpfreshstart_styles(){
    wp_register_style( 'wpfreshstart-css', plugins_url('/css/wpfreshstart-css.css', __FILE__) );
    wp_register_style( 'wpfreshstart-bootstrap', plugins_url('/css/bootstrap.min.css', __FILE__) );
    wp_enqueue_style( 'wpfreshstart-css' );
    wp_enqueue_style( 'wpfreshstart-bootstrap' );
}
function wpfreshstart_js() {
    /* Register our script. */
    wp_enqueue_script('jquery');
    wp_register_script( 'wpfreshstart-js', plugins_url( '/js/wpfreshstart.js', __FILE__ ), ('jquery') );
    wp_enqueue_script( 'wpfreshstart-js' );
}
function wpfreshstart_front_js() {
    /* Register our script. */
    // wp_enqueue_script('jquery');
    wp_register_script( 'wpfreshstart-front-js', plugins_url( '/js/wpfreshstart-front-js.js', __FILE__ ), ('jquery') );
    wp_enqueue_script( 'wpfreshstart-front-js' );
}
function wpfreshstart_options_data() {
    //register our settings
    register_setting( 'wpfreshstart_auto_pages_show', 'wpfreshstart_auto_pages_show_names' );
}
function wp_wpfreshstart_menu(){
    $page1 = add_menu_page( 'WP Freshstart', ' WP Freshstart', 'manage_options', 'wp-freshstart', 'wp_freshstart_menu_page', WP_FRESH_START_URL.'images/wp-fresh-icon.png');
    add_action( "admin_print_scripts-$page1", 'wpfreshstart_admin_scripts' );
    add_action( "admin_print_styles-$page1", 'wpfreshstart_admin_style' );
}

function wp_freshstart_menu_page(){
    if ( isset( $_POST['function'] ) && $_POST['function'] == 'do-clear' ) {
        wp_wpfreshstart_action();
    }
    else{
        require_once( 'clear-form.php' );
    }

}


function wpfreshstart_admin_scripts() {
    // wp_register_script( 'wpfreshstart_admin_js', WPFRESHSTART_URL . '/js/wpfreshstart-admin.js', array('jquery'), WPFRESHSTART_VERSION);
    // wp_enqueue_script( 'wpfreshstart_admin_js');

    wp_register_script( 'wpfreshstart_bootstrap_js', WPFRESHSTART_URL . '/assets/ui/js/bootstrap.min.js', array('jquery'), WPFRESHSTART_VERSION);
    wp_enqueue_script( 'wpfreshstart_bootstrap_js');

//     wp_register_script( 'wpfreshstart_bootstrap_switch_js', WPFRESHSTART_URL . '/assets/ui/js/bootstrap-switch.min.js', array('jquery'), WPFRESHSTART_VERSION);
//     wp_enqueue_script( 'wpfreshstart_bootstrap_switch_js');

//     wp_register_script( 'wpfreshstart_bootstrap_minicolors_js', WPFRESHSTART_URL . '/assets/ui/js/jquery.minicolors.min.js', array('jquery'), WPFRESHSTART_VERSION);
//     wp_enqueue_script( 'wpfreshstart_bootstrap_minicolors_js');

//     wp_register_script( 'wpfreshstart_bootstrap_spinedit_js', WPFRESHSTART_URL . '/assets/ui/js/bootstrap-spinedit.js', array('jquery'), WPFRESHSTART_VERSION);
//     wp_enqueue_script( 'wpfreshstart_bootstrap_spinedit_js');

//     wp_enqueue_script( 'jquery-ui-sortable' );

//     wp_enqueue_media( );
}

    function wpfreshstart_admin_style() {
        // wp_register_style('wpbeautify_admin_style', WPBEAUTIFY_URL . '/css/wpbeautify-admin.css', array(), WPBEAUTIFY_VERSION);
        // wp_enqueue_style('wpbeautify_admin_style');

        // wp_register_style('wpbeautify_effects', WPBEAUTIFY_URL . '/css/effects.css', array(), WPBEAUTIFY_VERSION);
        // wp_enqueue_style('wpbeautify_effects');

        wp_register_style('wpbeautify_bootstrap_css', WPFRESHSTART_URL . '/assets/ui/css/bootstrap-wpadmin.css', array(), WPBEAUTIFY_VERSION);
        wp_enqueue_style('wpbeautify_bootstrap_css');

        // wp_register_style('wpbeautify_bootstrap_switch_css', WPFRESHSTART_URL . '/assets/ui/css/bootstrap-switch.min.css', array(), WPBEAUTIFY_VERSION);
        // wp_enqueue_style('wpbeautify_bootstrap_switch_css');

        wp_register_style('wpbeautify_font_awesome_css', '//maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css', array(), WPBEAUTIFY_VERSION);
        wp_enqueue_style('wpbeautify_font_awesome_css');
        

        wp_register_style('wpbeautify_bootstrap_checkbox_css', WPFRESHSTART_URL . '/assets/ui/css/awesome-bootstrap-checkbox.css', array(), WPBEAUTIFY_VERSION);
        wp_enqueue_style('wpbeautify_bootstrap_checkbox_css');


        // wp_register_style('wpbeautify_bootstrap_spinedit_css', WPBEAUTIFY_URL . '/assets/ui/css/bootstrap-spinedit.css', array(), WPBEAUTIFY_VERSION);
        // wp_enqueue_style('wpbeautify_bootstrap_spinedit_css');
    }

/*  Licence Activation Page */

function wp_wpfreshstart_license_page() {
    $license 	= get_option( 'wp_wpfreshstart_license_key' );
    $status 	= get_option( 'wp_wpfreshstart_license_status' );
    ?>
    <div class="wrap" style="width: 600px;">
    <h2><img class="wpfreshstart-header-img" src="<?php echo WP_FRESH_START_URL.'images/wpfs3logo.png';?>" alt=""/></h2>
    <hr style="  border-top: 2px solid #7D7D7C;border-bottom: 0px;"/>
    <p>Please put the license key for "<?php echo ITEM_NAME; ?>" below</p>
    <p>To get the license key go to <a href="http://member.wpfreshstart.com">member.wpfreshstart.com</a> and use your username and password to login there that you received at the of purchase</p>

    <form method="post" action="options.php">

        <?php settings_fields('wp_wpfreshstart_license'); ?>

        <table class="form-table">
            <tbody>
            <tr valign="top">
                <th scope="row" valign="top">
                    <?php _e('License Key'); ?>
                </th>
                <td><?php if($status == 'invalid' ) { ?>
                        <p style="color:red;">Invalid License Key </p>
                    <?php } ?>
                    <input id="wp_wpfreshstart_license_key" name="wp_wpfreshstart_license_key" type="text" class="regular-text" value="<?php esc_attr_e( $license ); ?>" />
                    <label class="description" for="wp_wpfreshstart_license_key"><?php _e('Enter your license key'); ?></label>
                </td>
            </tr>
            <?php if( false !== $license ) { ?>
                <tr valign="top">
                    <th scope="row" valign="top">
                        <?php _e('Activate License'); ?>
                    </th>
                    <td>
                        <?php if( $status !== false && $status == 'valid' ) { ?>
                            <span style="color:green;"><?php _e('active'); ?></span>
                            <?php wp_nonce_field( 'wp_wpfreshstart_nonce', 'wp_wpfreshstart_nonce' ); ?>
                            <input type="submit" class="button-secondary" name="wp_wpfreshstart_license_deactivate" value="<?php _e('Deactivate License'); ?>"/>
                        <?php } else {
                            wp_nonce_field( 'wp_wpfreshstart_nonce', 'wp_wpfreshstart_nonce' ); ?>
                            <input type="submit" class="button-secondary" name="wp_wpfreshstart_license_activate" value="<?php _e('Activate License'); ?>"/>
                        <?php } ?>
                    </td>
                </tr>
            <?php } ?>
            </tbody>
        </table>
        <?php submit_button(); ?>
        <p>If you are having any trouble to activate the plugin please mail us at support@wpfreshstart.com.</p>
    </form>
<?php
}


/* All Actions */
function wpfreshstart_clear_file_get($cfile){
    $content=file_get_contents(WP_FRESH_START_URL.'pages/'.$cfile);
    $content=str_replace('[site_name]',get_bloginfo('name'),$content);
    $content=str_replace('[site_url]',get_bloginfo('wpurl'),$content);
    $content=str_replace('[site_description]',get_bloginfo('description'),$content);
    $content=str_replace('[admin_email]',get_bloginfo('admin_email'),$content);
    return $content;
}
function wp_wpfreshstart_action(){
    //Delete all posts
    if(isset($_POST['delete_posts']) && $_POST['delete_posts']=='on'){
        $all_posts = wp_count_posts('post'); //Total posts count before operation
        $count_posts = $all_posts->publish + $all_posts->draft;
        if ($count_posts > 0 ) {
            $args = array('post_type' => 'post');
            $posts = get_posts($args);
            foreach ($posts as $post) {
                wp_delete_post($post->ID, true);

            }

        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>There are no post(s) to delete.</li>";
        }

    }
    //Delete all pages
    if(isset($_POST['delete_pages']) && $_POST['delete_pages']=='on'){
        $all_pages = wp_count_posts('page'); //Total pages count before operation
        $count_pages = $all_pages->publish + $all_pages->draft;
        if($count_pages > 0 ) {
            $pages = get_pages();
            foreach ($pages as $page) {
                wp_delete_post($page->ID, true);
            }
            $delete_items['delete_pages']= "<li style='color:green;'><span class='bold'>✔ </span> All page(s) deleted successfully!</li>";
        }
        else{
            $delete_items['delete_pages']= "<li style='color:red;'><span class='bold'>✘ </span>There are no page(s) to delete.</li>";
        }

    }
    //Delete all comments

    if(isset($_POST['delete_comments']) && $_POST['delete_comments']=='on'){
        $comments_count = wp_count_comments();
        $comments_count = wp_count_comments();
        $all_comments = $comments_count->total_comments;
        $comments = get_comments();
        if($all_comments>0) {
            foreach ($comments as $comment) {
                wp_delete_comment($comment->comment_ID, true);
            }
            $delete_items[] = "<li style='color:green;'><span class='bold'>✔ </span> All comments deleted successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>There are no comment(s) to delete.</li>";
        }
    }

    //Permalink change
    if (isset($_POST['permalink_change']) && $_POST['permalink_change']=='on') {
        $par = get_option('permalink_structure');
        if ($par !== '/%postname%/') {
            global $wp_rewrite;
            $wp_rewrite->set_permalink_structure('/%postname%/');
            flush_rewrite_rules();
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span> Permalink Changed to /postname/ successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span> Permalink already set  as /postname/ </li>";
        }
    }
    //Stop new comment notification
    if(isset($_POST['stop_comment_notify']) && $_POST['stop_comment_notify']=='on'){
        $comments_not_setting = get_option('comments_notify');
        if($comments_not_setting==1){
            update_option('comments_notify',0);
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span>New comments notification by email disabled  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>New comments notification by email already disabled.</li>";
        }
    }

    //Stop moderate comment notification
    if(isset($_POST['stop_mod_com_notify']) && $_POST['stop_mod_com_notify']=='on'){
        $comments_mod_setting = get_option('moderation_notify');
        if($comments_mod_setting==1){
            update_option('moderation_notify',0);
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span>Moderate comments notification by email disabled  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>Moderate comments notification by email already disabled.</li>";
        }

    }
    //Multiple Category create
    if(isset($_POST['create_cat']) && $_POST['create_cat']=='on'){
        if(!empty($_POST['create_cats'])) {
            $categories = $_POST['create_cats'];
            $category = explode(',', $categories);
            for ($i = 0; $i < count($category); $i++) {
                if (0 == get_cat_ID('Uncategorized'))
                    wp_create_category($category[$i]);
                else {
                    $arr = array('cat_ID' => get_cat_ID('Uncategorized'), 'cat_name' => $category[$i]);
                    wp_insert_category($arr);
                }
            }
            $delete_items[] = "<li style='color:green;'><span class='bold'>✔ </span>" . $categories . " categories created  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span> You have not assigned any category to create.</li>";
        }
    }

    //About us page create
    if(isset($_POST['create_about_pg']) && $_POST['create_about_pg']=='on'){
        $title = 'About Us';
        if( null == get_page_by_title( $title ) ) {

            $page   =   array(
            'post_type'    => 'page',
            'post_content' => wpfreshstart_clear_file_get('about.txt'),
            'post_author'  => 1,
            'post_status'  => 'publish',
            'post_title'   => $title,
        );
            wp_insert_post ($page);
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span>About us page created  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span> About us page already created </li>";
        }
        $wpfreshstart_created_pages[]= "About Us";
    }
    //privacy policy page create
    if(isset($_POST['create_privacy_pg']) && $_POST['create_privacy_pg']=='on'){
        $title = 'Privacy Policy';
        if( null == get_page_by_title( $title ) ) {
            $page   =   array(
            'post_type'    => 'page',
            'post_content' => wpfreshstart_clear_file_get('privacy.txt'),
            'post_author'  => 1,
            'post_status'  => 'publish',
            'post_title'   => $title,
        );
           wp_insert_post ($page);
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span>Privacy policy page created  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>Privacy policy page already created </li>";
        }
        $wpfreshstart_created_pages[]= "Privacy Policy";
    }
    //privacy policy page create
    if(isset($_POST['create_terms_pg']) && $_POST['create_terms_pg']=='on'){
        $title = 'Terms of Use';
        if( null == get_page_by_title( $title ) ) {

            $page   =   array(
            'post_type'    => 'page',
            'post_content' => wpfreshstart_clear_file_get('termspage.txt'),
            'post_author'  => 1,
            'post_status'  => 'publish',
            'post_title'   => $title,
        );
            wp_insert_post ($page);
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span>Terms of Use page created  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>Terms of Use page already created </li>";
        }
        $wpfreshstart_created_pages[]= "Terms of Use";
    }
    //privacy policy page create
    if(isset($_POST['create_disclaimer_pg']) && $_POST['create_disclaimer_pg']=='on'){
        $title = 'Disclaimer';
        if( null == get_page_by_title( $title ) ) {

            $page   =   array(
            'post_type'    => 'page',
            'post_content' => wpfreshstart_clear_file_get('earnings.txt'),
            'post_author'  => 1,
            'post_status'  => 'publish',
            'post_title'   => $title,
        );
            wp_insert_post ($page);
            $wpclst_add_pages[] = "earning_pg";
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span>Disclaimer page created  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>Disclaimer page already created </li>";
        }
        $wpfreshstart_created_pages[]= "Disclaimer";
    }
    //privacy policy page create
    if(isset($_POST['create_contact_pg']) && $_POST['create_contact_pg']=='on'){
        $title = 'Contact Us';
        if( null == get_page_by_title( $title ) ) {

            $page   =   array(
            'post_type'    => 'page',
            'post_content' => wpfreshstart_clear_file_get('contact.txt'),
            'post_author'  => 1,
            'post_status'  => 'publish',
            'post_title'   => $title,
        );
            wp_insert_post ($page);
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span>Contact Us page created  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>Contact Us page already created </li>";
        }
        $wpfreshstart_created_pages[]= "Contact Us";
    }
    //Create Affiliate Disclosure (FTC Statement page)
    if(isset($_POST['create_disclosure_pg']) && $_POST['create_disclosure_pg']=='on'){
        $title = 'Affiliate Disclosure';
        if( null == get_page_by_title( $title ) ) {

            $page   =   array(
            'post_type'    => 'page',
            'post_content' => wpfreshstart_clear_file_get('disclosure.txt'),
            'post_author'  => 1,
            'post_status'  => 'publish',
            'post_title'   => $title,
        );
            wp_insert_post ($page);
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span>Affiliate Disclosure page created  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>Affiliate Disclosure page already created </li>";
        }
        $wpfreshstart_created_pages[]= "Affiliate Disclosure";
    }
    // Create Copyright / DMCA Notice page
    if(isset($_POST['create_copy_right_pg']) && $_POST['create_copy_right_pg']=='on'){
        $title = 'Digital Millennium Copyright Act Notice';
        if( null == get_page_by_title( $title ) ) {

            $page   =   array(
            'post_type'    => 'page',
            'post_content' => wpfreshstart_clear_file_get('copyright.txt'),
            'post_author'  => 1,
            'post_status'  => 'publish',
            'post_title'   => $title,
        );
            wp_insert_post ($page);
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span>Copyright / DMCA Notice page created  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>Copyright / DMCA Notice page already created </li>";
        }
        $wpfreshstart_created_pages[]= "Digital Millennium Copyright Act Notice";
    }
    //Create Ani-Spam page
    if(isset($_POST['create_anti_spam_pg']) && $_POST['create_anti_spam_pg']=='on'){
        $title = 'Anti Spam Policy';
        if( null == get_page_by_title( $title ) ) {

            $page   =   array(
            'post_type'    => 'page',
            'post_content' => wpfreshstart_clear_file_get('anti-spam.txt'),
            'post_author'  => 1,
            'post_status'  => 'publish',
            'post_title'   => $title,
        );
            wp_insert_post ($page);
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span>Anti SPAM Policy page created  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>Anti SPAM Policy page already created </li>";
        }
    $wpfreshstart_created_pages[]= "Anti Spam Policy";
    }
    //Create Medical Disclaimer page
    if(isset($_POST['create_medical_pg']) && $_POST['create_medical_pg']=='on'){
        $title = 'Medical Disclaimer';
        if( null == get_page_by_title( $title ) ) {

            $page   =   array(
            'post_type'    => 'page',
            'post_content' => wpfreshstart_clear_file_get('medical.txt'),
            'post_author'  => 1,
            'post_status'  => 'publish',
            'post_title'   => $title,
        );
            wp_insert_post ($page);
            $wpclst_add_pages[] = "medicaldis_pg";
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span>Medical Disclaimer page created  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>Medical Disclaimer page already created </li>";
        }
        $wpfreshstart_created_pages[]= "Medical Disclaimer";
    }
    //Create Amazon Associate Programs page
    if(isset($_POST['create_amazon_pg']) && $_POST['create_amazon_pg']=='on'){
        $title = 'Amazon Affiliate Disclaimer';
        //$abl = wpfreshstart_clear_file_get($_POST['create_amazon']);
        $am_ca = 'The owner of this website is a participant in the Amazon.com.ca, Inc. Associates Program, an affiliate advertising program designed to provide a means for sites to earn advertising fees by advertising and linking to Amazon.ca.';
        $am_de = SITE_NAME.  ' ist Teilnehmer des Partnerprogramms von Amazon EU, das zur Bereitstellung eines Mediums für Websites konzipiert wurde, mittels dessen durch die Platzierung von Werbeanzeigen und Links zu [bitte fügen Sie hier den zutreffenden Namen der Website ein Amazon.de, Javari.de, de.BuyVIP.com Werbekostenerstattung verdient werden kann.';
        $am_es = SITE_NAME. ' participa en el Programa de Afiliados de Amazon EU, un programa de publicidad para afiliados diseñado para ofrecer a sitios web un modo de obtener comisiones por publicidad, publicitando e incluyendo enlaces a Amazon.es, es.buyvip.com.';
        $am_fr = SITE_NAME. ' participe au Programme Partenaires d’Amazon EU, un programme d’affiliation conçu pour permettre à des sites de percevoir une rémunération grâce à la création de liens vers Amazon.fr, Javari.fr.';
        $am_it = SITE_NAME. ' partecipa al Programma Affiliazione Amazon EU, un programma di affiliazione che consente ai siti di percepire una commissione pubblicitaria pubblicizzando e fornendo link al sito Amazon.it, it.BuyVIP.com.';
        $am_uk = 'The owner of this website is a participant in the Amazon EU Associates Programme, an affiliate advertising programme designed to provide a means for sites to earn advertising fees by advertising and linking to [insert applicable site name Amazon.co.uk, Javari.co.uk.';
        $am_us = 'The owner of this website is a participant in the Amazon Services LLC Associates Program, an affiliate advertising program designed to provide a means for sites to earn advertising fees by advertising and linking to Amazon properties including, but not limited to, amazon.com, endless.com, myhabit.com, smallparts.com, or amazonwireless.com.';

        if( null == get_page_by_title( $title ) ) {
            $page   =   array(
            'post_type'    => 'page',
            'post_content' => $$_POST['create_amazon'],
            'post_author'  => 1,
            'post_status'  => 'publish',
            'post_title'   => $title,
        );
            wp_insert_post ($page);
            $wpclst_add_pages[] = "amazon_pg";
            $delete_items[]= "<li style='color:green;'><span class='bold'>✔ </span>Amazon Affiliate Disclaimer page created  successfully!</li>";
        }
        else{
            $delete_items[]= "<li style='color:red;'><span class='bold'>✘ </span>Amazon Affiliate Disclaimer page already created </li>";
        }
        $wpfreshstart_created_pages[]= "Amazon Affiliate Disclaimer";
    }


    //multiple pages
    if(isset($_POST['multiple_blank_pages']) && $_POST['multiple_blank_pages']=='on'){
        if(!empty($_POST['create_multiple_blank_pages'])) {
            $page = $_POST['create_multiple_blank_pages'];
            $allpage = array();
            $post = array();
            $newpages = explode(',', $page);
            foreach ($newpages as $newpage) {
                for($i=0;$i<count($newpage);$i++){
                if (!get_page_by_title($newpage)) {
                    $bulk_pages = array(
                        'post_title' => $newpage,
                        'post_type' =>  'page',
                        'post_content' => 'This page is created by WP wpfreshstart Wordpress plugin.',
                        'post_status' => 'publish',
                        'post_author' => 1,
                    );

// Insert the post into the database
                    wp_insert_post($bulk_pages);
                }
            }

            }
            $delete_items[] = "<li style='color:green;'><span class='bold'>✔ </span>" . $page . "page(s) created  successfully!</li>";
        }
    }


        //multiple posts
        if(isset($_POST['multiple_blank_posts']) && $_POST['multiple_blank_posts']=='on'){
            if(!empty($_POST['create_multiple_blank_posts'])) {
                $post_list = $_POST['create_multiple_blank_posts'];
                $allpost = array();
                $post = array();
                $newposts = explode(',', $post_list);
                foreach ($newposts as $newpost) {
                    for($i=0;$i<count($newpost);$i++){
                    if (!get_page_by_title($newpost)) {
                        $bulk_posts = array(
                            'post_title' => $newpost,
                            'post_type' =>  'post',
                            'post_content' => 'This post is created by WP wpfreshstart Wordpress plugin.',
                            'post_status' => 'publish',
                            'post_author' => 1,
                        );

    // Insert the post into the database
                        wp_insert_post($bulk_posts);
                    }
                }

                }
                $delete_items[] = "<li style='color:green;'><span class='bold'>✔ </span>" . $post_list . " post(s) created  successfully!</li>";
            }
        }
    //starting php
    ?>
    <div class='wrap'>
    <div class="bootstrap-wpbtfy-wpadmin">
        <div class="container">
            <div class="col-md-12">
                <div class="row">
    <!-- <div class="wpfreshstart-wrp" style="width: 500px;"> -->
        <h2><img class="wpfreshstart-header-img" src="<?php echo WP_FRESH_START_URL.'images/wpfs3logo.png';?>" alt=""/></h2>
        <hr style="  border-top: 2px solid #7D7D7C;border-bottom: 0px;"/>
        <ul>
        <?php
        if ( isset( $_POST['function'] ) && $_POST['function'] == 'do-clear' ) {
            if (isset($delete_items)) {
            echo "<pre>";

                foreach($delete_items as $delete_item)
                    echo "<li>". $delete_item. "</li>";
                //foreach($delete_items as $delete_item){
                //echo $delete_item;
                // }
                echo "</pre>";
            } else {
                echo '<div class="alert alert-warning" role="alert"><i class="fa fa-warning"></i> Sorry you have not set any action to do. <a href="'.admin_url('admin.php?page=wp-freshstart').'">Try again</a></div>';
            }
            //multiple

            if(isset($_POST['multiple_plugins']) && $_POST['multiple_plugins']=='on'){
                if(!empty($_POST['create_multiple_plugins'])) {
                    $url = $_POST['create_multiple_plugins'];
                    $newurls = explode(',', $url);
                    require_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');
                    require_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                    function install_plugin($url)
                    {
                        if (strstr($url, '.zip') != FALSE) {
                            $download_link = $url;
                        } else {
                            $slug = explode('/', $url);
                            $slug = $slug[count($slug) - 2];
                            $api = plugins_api('plugin_information', array('slug' => $slug, 'fields' => array('sections' => 'false')));
                            $download_link = $api->download_link;
                        }

                        $upgrader = new Plugin_Upgrader();
                        if (!$upgrader->install($download_link))
                            return 0;
                        $plugin_to_activate = $upgrader->plugin_info();
                        $activate = activate_plugin($plugin_to_activate);
                        wp_cache_flush();

                        return 1;
                    }

                    for ($i = 0; $i < count($newurls); $i++) {
                        install_plugin($newurls[$i]);
                    }
                }
            }
        }
    ?>

    </ul>
        <hr style="  border-top: 2px solid #7D7D7C;border-bottom: 0px;"/>
        <?php if(0 && !is_null($wpfreshstart_created_pages)){?>
        <b>Please check the pages to appear automatically at the footer:</b>
        <hr style="  border-top: 2px solid #7D7D7C;border-bottom: 0px;"/>

        <form method="post" action="options.php">
        <?php
        settings_fields('wpfreshstart_auto_pages_show');
        do_settings_sections('wpfreshstart_auto_pages_show');
        ?>

        <?php foreach($wpfreshstart_created_pages as $wpfreshstart_created_page){ ?>


        <div class="checkbox  checkbox-success">
          <input type="checkbox" name="<?php echo $wpfreshstart_created_page; ?>" id="<?php echo $wpfreshstart_created_page; ?>" value="<?php echo $wpfreshstart_created_page; ?>" class="add_pages"/>
            <label for="<?php echo $wpfreshstart_created_page; ?>"><?php echo $wpfreshstart_created_page; ?></label>
        </div>


            <?php } ?>

            <input name="wpfreshstart_auto_pages_show_names" id="update" type="text" value="wpfreshstart_auto_pages_show_names[]" style="display: none"/>
            <br/>
            <button type="submit" value="" class="btn btn-primary"><i class="fa fa-check"></i> Save Changes</button>
        <?php /*submit_button();*/ ?>
        </form>
        <?php } ?>
            <a href="<?php echo admin_url('admin.php?page=wp-freshstart'); ?>" class="btn btn-primary"><i class="fa fa-arrow-left"></i> Return</a>

        </div>
    </div>
    </div>
    </div>
    </div>
    </div>
        <?php } ?>