<?php
// Template Name: BZ Sitemap Page
/**
 *
 * @package progression
 * @since progression 1.0
 */
get_header();
?>


<?php while (have_posts()) : the_post(); ?>
    <div id="content-container">	
        <div class="element-title"><h1 class="solar-post-headline"><?php the_title(); ?></h1></div>
        
                                <h3 class="h3">All Posts</h3>
                                <div class="sitemapallpost">
                                    <?php
                                    $recent_posts = get_posts('numberposts=999&orderby=title&order=asc&posts_per_page=-1'); //angka 6 = jumlah postingan yang mau ditampilkan
                                    foreach ($recent_posts as $post) :
                                        setup_postdata($post);
                                        ?>
                                        <a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><h4 class="h4"><stong><?php the_title(); ?></stong></h4></a>
                                        <?php
                                        $args = array(
                                            'post_type' => 'attachment',
                                            'numberposts' => -1,
                                            "orderby" => "rand",
                                            "order" => "rand",
                                            'post_status' => null,
                                            'post_parent' => $post->ID
                                        );
                                        $attachments = get_posts($args);
                                        if ($attachments) {
                                            echo "<ul id='double'>";
                                            foreach ($attachments as $attachment) {
                                                echo '<li class="sitemap">';
                                                $attachment_page = get_attachment_link($attachment->ID);
                                                ?>
                                                <a href="<?php echo $attachment_page; ?>" title="<?php echo get_the_title($attachment->ID); ?>"><?php echo get_the_title($attachment->ID); ?></a>
                                                <?php
                                                echo '</li>';
                                            }
                                            echo "</ul>";
                                            echo '<div class="clearfix"></div>';
                                        }
                                        ?>
                                    <?php endforeach; ?>
                                </div>
                                <div class="clearfix"></div>
                                <h3 class="h3">All Categories</h3>
                                <ul id="double">
                                    <?php wp_list_cats('optioncount=1'); ?>
                                </ul>
                                <div class="clearfix"></div>
                                <h3 class="h3">All Tags</h3>
                                <p><?php wp_tag_cloud(); ?></p>
        <div class="clearfix">

        </div>	
    </div><!-- close #content-container -->			
<?php endwhile; // end of the loop. ?>
<div id="sidebar">
	<?php if ( ! dynamic_sidebar( 'homepage-sidebar' ) ) : ?><?php endif; // end sidebar widget area ?>
<div class="clearfix"></div>
</div>
<?php get_footer(); ?>