<?php
/**
 * @package aThemes
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?>>
    <header class="entry-header">
        <?php if (!post_password_required() && ( comments_open() || '0' != get_comments_number() )) : ?>
            <span class="comments-link"> <?php comments_popup_link(__('0', 'athemes'), __('1', 'athemes'), __('%', 'athemes')); ?></span>
        <?php endif; ?>

        <h1 class="entry-title heading-single"><?php the_title(); ?></h1>
        <?php if (get_option('business_toplargesingleads') != "") { ?>
            <div class="TopSingleAds-728">
                <?php
                if (get_option('business_toplargesingleads') <> "") {
                    echo stripslashes(stripslashes(get_option('business_toplargesingleads')));
                }
                ?></div>
        <?php } ?>
        <div class="entry-meta">
            <?php
            if ($images = get_children(array(
                'post_parent' => get_the_ID(),
                'post_type' => 'attachment',
                'numberposts' => 1,
                'post_mime_type' => 'image',
                'orderby' => 'rand',
                    ))) :
                ?>
                <?php foreach ($images as $image) : ?>
                    <div class="single-thumbnail">
                        <?php echo wp_get_attachment_link($image->ID, $post->ID, 'full'); ?>
                    </div>
                <?php endforeach; ?>

            <?php else: // No images ?>
                <!-- This post has no attached images -->
            <?php endif; ?>	
            <!-- .entry-meta --></div>
        <!-- .entry-header --></header>

    <?php if ((has_post_thumbnail()) && ( get_theme_mod('athemes_post_img'))) : ?>
        <div class="single-thumbnail">
            <?php
            global $post;
            $attachments = get_children(array('post_parent' => get_the_ID(), 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => 'ASC', 'orderby' => 'menu_order ID'));

            $count = count($attachments);
            $specific = array();
            $i = 1;
            $alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
            if (count($alt))
                echo $alt;

            foreach ($attachments as $attachment) {
                $specific[$attachment->ID] = $i;
                ++$i;
            }
            ?>
        </div>	
    <?php endif; ?>		

    <div class="clearfix entry-content">
        <?php if (get_option('business_middlelargesingleads') != "") { ?>
            <div class="MiddleSingleAds-728">
                <?php
                if (get_option('business_middlelargesingleads') <> "") {
                    echo stripslashes(stripslashes(get_option('business_middlelargesingleads')));
                }
                ?></div>
        <?php } ?>





        <?php the_content(); ?>

        <?php
        wp_link_pages(array(
            'before' => '<div class="page-links">' . __('Pages:', 'athemes'),
            'after' => '</div>',
        ));
        ?>       

        <div class="clear"></div>
        <h2><?php
            global $post;
            $attachments = get_children(array('post_parent' => get_the_ID(), 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => 'ASC', 'orderby' => 'menu_order ID'));
            $count = count($attachments);
            $specific = array();
            $i = 1;
            foreach ($attachments as $attachment) {
                $specific[$attachment->ID] = $i;
                ++$i;
            }
            echo "{$specific[$post->ID]} {$count}";
            ?> Photos Gallery of: <?php the_title(); ?>
        </h2>

<?php if (get_option('business_medianet') != "") { ?>
        <div class="singleads">
            <?php
            if (get_option('business_medianet') <> "") {
                echo stripslashes(stripslashes(get_option('business_medianet')));
            }
            ?></div>
    <?php } ?>

        <div id="gallerysingle">
            <?php gallerysingle(); ?>
        </div>

        <?php if (get_option('business_middlesquaresingleads') != "") { ?>
            <div class="MiddleSingleAds-336">
                <?php
                if (get_option('business_middlesquaresingleads') <> "") {
                    echo stripslashes(stripslashes(get_option('business_middlesquaresingleads')));
                }
                ?>
            </div>
        <?php } ?>

        <!-- .entry-content -->

        <footer class="entry-meta entry-footer">
            <?php
            /* translators: used between list items, there is a space after the comma */
            $category_list = get_the_category_list(__(', ', 'athemes'));

            /* translators: used between list items, there is a space after the comma */
            $tag_list = '';

            if (!athemes_categorized_blog()) {
                // This blog only has 1 category so we just need to worry about tags in the meta text
                if ('' != $tag_list) {
                    $meta_text = __('<span class="tags-links"><i class="ico-tags"></i> %2$s</span>', 'athemes');
                }
            } else {
                // But this blog has loads of categories so we should probably display them here
                if ('' != $tag_list) {
                    $meta_text = __('<span class="cat-links"><i class="ico-folder"></i> %1$s</span><span class="tags-links"><i class="ico-tags"></i> %2$s</span>', 'athemes');
                } else {
                    $meta_text = __('<span class="cat-links"><i class="ico-folder"></i> %1$s</span>', 'athemes');
                }
            } // end check for categories on this blog

            printf(
                    $meta_text, $category_list, $tag_list
            );
            ?>
            <!-- .entry-meta --></footer>
        <!-- #post-<?php the_ID(); ?> -->

<div class="relatedss">
    <h3>Related Post from <?php the_title(); ?></h3>

    <?php if ( is_single() OR is_attachment() ) { ?>
        <?php if ( get_option( 'business_matchedcontent' ) != "" ) { ?>
            <div id="matchedcontent-ads">
                <?php
                if ( get_option( 'business_matchedcontent' ) <> "" ) {
                    echo stripslashes( stripslashes( get_option( 'business_matchedcontent' ) ) );
                }
                ?>
            </div>
        <?php } ?>
    <?php } ?>

        <ul>
            <?php
            $recent_posts = get_posts('numberposts=3&orderby=rand'); //angka 6 = jumlah postingan yang mau ditampilkan
            foreach ($recent_posts as $post) :
                setup_postdata($post);
                $the_excerpt = substr( get_the_excerpt(), 0, 200 );
                $the_excerpt = trim( preg_replace( '/\s+/', ' ', $the_excerpt ) );
                ?>
                <li class="clearfix">
                    <div class="widget-entry-thumbnail">
                        <?php relateds(); ?>
                    </div>
                    <div class="widget-entry-summary">
                        <h4><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a></h4>

                        <p><?php echo $the_excerpt;?></p>

                    </div>
                    <div class="clear"></div>
                </li>
            <?php endforeach; ?>
        </ul>
</div>

</article>