<?php
/**
 * aThemes functions and definitions
 *
 * @package aThemes
 */
if (!function_exists('athemes_setup')) :

    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which runs
     * before the init hook. The init hook is too late for some features, such as indicating
     * support post thumbnails.
     */
    function athemes_setup() {

        /**
         * Make theme available for translation
         * Translations can be filed in the /lang/ directory
         * If you're building a theme based on aThemes, use a find and replace
         * to change 'athemes' to the name of your theme in all the template files
         */
        load_theme_textdomain('athemes', get_template_directory() . '/lang');

        /**
         * Add default posts and comments RSS feed links to head
         */
        add_theme_support('automatic-feed-links');

        // Set the content width based on the theme's design and stylesheet.
        global $content_width;
        if (!isset($content_width)) {
            $content_width = 640; /* pixels */
        }

        /**
         * Enable support for Post Thumbnails on posts and pages
         *
         * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
         */
        add_theme_support('post-thumbnails');
        add_image_size('thumb-small', 50, 50, true);
        add_image_size('thumb-medium', 300, 135, true);
        add_image_size('thumb-featured', 250, 175, true);

        /**
         * This theme uses wp_nav_menu() in one location.
         */
        register_nav_menus(array(
            'main' => __('Main Menu', 'athemes'),
        ));
    }

endif; // athemes_setup
add_action('after_setup_theme', 'athemes_setup');

/**
 * Register widgetized area and update sidebar with default widgets
 */
function athemes_widgets_init() {
    register_sidebar(array(
        'name' => __('Sidebar', 'athemes'),
        'id' => 'sidebar-1',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ));
    register_sidebar(array(
        'name' => __('Header', 'athemes'),
        'id' => 'sidebar-2',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ));
    register_sidebar(array(
        'name' => __('Sub Footer 1', 'athemes'),
        'id' => 'sidebar-3',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ));
    register_sidebar(array(
        'name' => __('Sub Footer 2', 'athemes'),
        'id' => 'sidebar-4',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ));
    register_sidebar(array(
        'name' => __('Sub Footer 3', 'athemes'),
        'id' => 'sidebar-5',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ));
    register_sidebar(array(
        'name' => __('Sub Footer 4', 'athemes'),
        'id' => 'sidebar-6',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ));
}

add_action('widgets_init', 'athemes_widgets_init');

/**
 * Count the number of footer sidebars to enable dynamic classes for the footer
 *
 * @since aThemes 1.0
 */
function athemes_footer_sidebar_class() {
    $count = 0;

    if (is_active_sidebar('sidebar-3'))
        $count++;

    if (is_active_sidebar('sidebar-4'))
        $count++;

    if (is_active_sidebar('sidebar-5'))
        $count++;

    if (is_active_sidebar('sidebar-6'))
        $count++;

    $class = '';

    switch ($count) {
        case '1':
            $class = 'site-extra extra-one';
            break;
        case '2':
            $class = 'site-extra extra-two';
            break;
        case '3':
            $class = 'site-extra extra-three';
            break;
        case '4':
            $class = 'site-extra extra-four';
            break;
    }

    if ($class)
        echo 'class="' . $class . '"';
}

/**
 * Enqueue scripts and styles
 */
function athemes_scripts() {

    //Load the fonts
    $headings_font = esc_html(get_theme_mod('headings_fonts'));
    $body_font = esc_html(get_theme_mod('body_fonts'));
    if ($headings_font) {
        wp_enqueue_style('athemes-headings-fonts', '//fonts.googleapis.com/css?family=' . $headings_font);
    } else {
        wp_enqueue_style('athemes-headings-fonts', '//fonts.googleapis.com/css?family=Yanone+Kaffeesatz:200,300,400,700');
    }
    if ($body_font) {
        wp_enqueue_style('athemes-body-fonts', '//fonts.googleapis.com/css?family=' . $body_font);
    }

    wp_enqueue_style('athemes-glyphs', get_template_directory_uri() . '/css/athemes-glyphs.css');

    wp_enqueue_style('athemes-bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css');
    wp_enqueue_style('athemes-style', get_stylesheet_uri());

    wp_enqueue_script('athemes-bootstrap-js', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'));
    wp_enqueue_script('athemes-superfish', get_template_directory_uri() . '/js/superfish.js', array('jquery'));
    wp_enqueue_script('athemes-supersubs', get_template_directory_uri() . '/js/supersubs.js', array('jquery'));
    wp_enqueue_script('athemes-settings', get_template_directory_uri() . '/js/settings.js', array('jquery'));

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}

add_action('wp_enqueue_scripts', 'athemes_scripts');

/**
 * Load html5shiv
 */
function athemes_html5shiv() {
    echo '<!--[if lt IE 9]>' . "\n";
    echo '<script src="' . esc_url(get_template_directory_uri() . '/js/html5shiv.js') . '"></script>' . "\n";
    echo '<![endif]-->' . "\n";
}

add_action('wp_head', 'athemes_html5shiv');

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Add social links on user profile page.
 */
require get_template_directory() . '/inc/user-profile.php';

/**
 * Add custom widgets
 */
require get_template_directory() . '/inc/custom-widgets.php';
/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';
/**
 * Dynamic styles
 */
require get_template_directory() . '/styles.php';
/* ---------------CUSTOM IMG SINGLE ---------- */

function gallerysingle($args = array()) {

    $get_posts_args = array(
        "post_parent" => get_the_ID(),
        "what_to_show" => "posts",
        "post_type" => "attachment",
        "orderby" => "RAND",
        "order" => "RAND",
        "showposts" => 999,
        "post_mime_type" => "image/jpeg,image/jpg,image/gif,image/png");
    $posts = get_posts($get_posts_args);
    foreach ($posts as $post) {
        $parent = get_post($post->post_parent);
        if (($imgsrc = wp_get_attachment_image($post->ID, 'full')) && ($imglink = get_attachment_link($post->ID)) && $parent->post_status == "publish") {
            echo "<a href='" . $imglink . "'>" . $imgsrc . "</a>";
        }
    }
}

/* ---------------CUSTOM IMG ATT ---------- */

function gb() {
    global $post;
    $pos = get_post($post);
    if ($gb = get_children(array(
        'post_parent' => $pos->post_parent,
        'post_type' => 'attachment',
        'numberposts' => 50,
        'post_mime_type' => 'image',))) {
        foreach ($gb as $gbr) {
            $url = get_attachment_link($gbr->ID);
            $gambar = wp_get_attachment_image($gbr->ID, 'thumb');
            echo '<a href="' . $url . '">' . $gambar . '</a>';
        }
    }
}

/* ---------------END CUSTOM IMG ATT ---------- */

/** JS SPIN -----------------------------------------------------
 * Simple spinner
 */
function js_spin($s) {
    $s = str_replace(array('{', '}'), '', $s);
    $e = explode("|", $s);
    $c = count($e);
    $l = $c - 1;
    $i = mt_rand(0, $l);
    $t = $e[$i];
    return $t;
}

/* sgl tags */

function sgl_tags() {
    global $post;
    if (is_attachment()) {
        $postid = $post->post_parent;
    } else {
        $postid = $post->ID;
    }
    //tags
    $tags = get_the_tags($postid);
    if ($tags) {
        $i = 1;
        $limit = 5;
        $nw = 'rel="nofollow"';
        shuffle($tags);
        echo 'Tags :';
        foreach ($tags as $tag) {
            if ($i > $limit) {
                break;
            } else {
                $tagname = $tag->name;
                $taglink = get_tag_link($tag->term_id);
                if ($i == $limit) {
                    $comma = '';
                } else {
                    $comma = ',';
                }
                echo '<a ' . $nw . ' href="' . $taglink . '">' . $tagname . '</a>' . $comma . ' ';
            }
            $i++;
        }
    }
}

// End of sgl tags ---------------------------------------------------
/* ---------------CUSTOM IMG RELATED ---------- */
function relateds($args = array()) {

    $get_posts_args = array(
        "post_parent" => get_the_ID(),
        "what_to_show" => "posts",
        "post_type" => "attachment",
        "orderby" => "RAND",
        "order" => "RAND",
        "showposts" => 1,
        "post_mime_type" => "image/jpeg,image/jpg,image/gif,image/png");
    $posts = get_posts($get_posts_args);
    foreach ($posts as $post) {
        $parent = get_post($post->post_parent);
        if (($imgsrc = wp_get_attachment_image($post->ID, 'full')) && ($imglink = get_attachment_link($post->ID)) && $parent->post_status == "publish") {
            echo "<a href='" . $imglink . "'>" . $imgsrc . "</a>";
        }
    }
}


function an_excerptlength_archive($length) {
    return 60;
}

function an_excerptlength_index($length) {
    return 70;
}

function an_excerptlength_related($length) {
    return 60;
}

function an_excerpt($length_callback = '', $more_callback = '') {
    global $post;
    if (function_exists($length_callback)) {
        add_filter('excerpt_length', $length_callback);
    }
    if (function_exists($more_callback)) {
        add_filter('excerpt_more', $more_callback);
    }
    $output = get_the_excerpt();
    $output = apply_filters('wptexturize', $output);
    $output = apply_filters('convert_chars', $output);
    $output = '<p>' . $output . '</p>';
    echo $output;
}

/* ------------------- END CUSTOM EXCERPTS --------------------- */

function randimg($args = array()) {
    global $wpdb;
    $get_posts_args = array(
        "post_parent" => get_the_ID(),
        "what_to_show" => "posts",
        "post_status" => null,
        "post_type" => "attachment",
        'orderby' => 'rand',
        "showposts" => 5,
        "post_mime_type" => "image/jpeg,image/jpg,image/gif,image/png");
    $nofollow = 'rel="nofollow"';
    $posts = get_posts($get_posts_args);
    foreach ($posts as $post) {
        $parent = get_post($post->post_parent);
        if (($imgsrc = wp_get_attachment_image($post->ID)) && ($imglink = get_attachment_link($post->ID)) && $parent->post_status == "publish") {
            echo "<a " . $nofollow . "href='" . $imglink . "'>" . $imgsrc . "</a>";
        }
    }
}
?>
<?php

function attachment_toolbox($size = thumbnail) {
    if ($images = get_children(array(
        'post_parent' => get_the_ID(),
        'post_type' => 'attachment',
        'numberposts' => 1,
        'post_status' => null,
        'post_mime_type' => 'image',
        'order' => 'ASC',
        'orderby' => 'menu_order ID'
            ))) {
        foreach ($images as $image) {
            $attimg = wp_get_attachment_image($image->ID, $size);
            $atturl = wp_get_attachment_url($image->ID);
            $attlink = get_attachment_link($image->ID);
            $postlink = get_permalink($image->post_parent);
            $atttitle = apply_filters('the_title', $image->post_title);
            echo '<a href="' . $postlink . '">' . $attimg . '</a>';
        }
    }
}

function ngopi_text($s) {
    $s = str_replace(array('{', '}'), '', $s);
    $e = explode("|", $s);
    $c = count($e);
    $l = $c - 1;
    $i = mt_rand(0, $l);
    $t = $e[$i];
    return $t;
}

add_action('widgets_init', 'my_archives_widget_init');

// Register my archives widget
function my_archives_widget_init() {
    register_sidebar_widget('My Archives Widget', 'my_archives_widget');
}

add_custom_background();
if (function_exists('register_sidebar'))
    register_sidebars(1);
add_action('admin_menu', 'business_theme_page');

function business_theme_page() {
    if (count($_POST) > 0 && isset($_POST['business_settings'])) {
        $options = array('medianet','matchedcontent','topheader','toplargesingleads', 'middlelargesingleads', 'middlesquaresingleads', 'toplargeattachmentads', 'middlelargeattachmentads', 'middlesquareattachmentads', 'sidebarsingleattahmentads', 'footerscripts', 'headerscripts');
        foreach ($options as $opt) {
            delete_option('business_' . $opt, $_POST[$opt]);
            add_option('business_' . $opt, $_POST[$opt]);
        }
    }
    //add_theme_page(__('TukangNgopi'), __('TukangNgopi'), 'edit_themes', basename(__FILE__), 'business_settings');
    add_menu_page('TukangNgopi Coffee Menus', 'TukangNgopi', 10, 'tukangngopi.php', 'business_settings');
}

function business_settings() {
    ?>
    <h2>TukangNgopi&trade; Coffee Menus</h2>
    <p>          
    <form method="post" action="">
        <table class="form-table">
        <tr valign="top">
                        <th scope="row"><label for="topheader">Top Header Ads</label></th>
                        <td>
                        <textarea cols="40" rows="6" name="topheader" id="topheader"/><?php echo stripslashes(get_option('business_topheader')); ?></textarea>
                            <div style="font-size:11px;margin-top:6px;font-style:italic;">Recommended ad sizes: responsive</div>
                        </td>
        </tr>
            <tr valign="top">
                <th scope="row"><label for="toplargesingleads">Top Single Ads</label></th>
                <td>
                    <textarea cols="40" rows="6" name="toplargesingleads" id="toplargesingleads" /><?php echo stripslashes(get_option('business_toplargesingleads')); ?></textarea>
                    <div style="font-size:11px;margin-top:6px;font-style:italic;">Recommended ad sizes: <strong>728x90</strong></div>
                </td>
            </tr>   
            <tr valign="top">
                <th scope="row"><label for="middlelargesingleads">Middle Single Ads</label></th>
                <td>
                    <textarea cols="40" rows="6" name="middlelargesingleads" id="middlelargesingleads" /><?php echo stripslashes(get_option('business_middlelargesingleads')); ?></textarea>
                    <div style="font-size:11px;margin-top:6px;font-style:italic;">Recommended ad sizes: <strong>728x90</strong></div>
                </td>
            </tr>
            <tr valign="top">
                <th scope="row"><label for="toplargeattachmentads">Top Attachment Ads</label></th>
                <td>
                    <textarea cols="40" rows="6" name="toplargeattachmentads" id="toplargeattachmentads" /><?php echo stripslashes(get_option('business_toplargeattachmentads')); ?></textarea>
                    <div style="font-size:11px;margin-top:6px;font-style:italic;">Recommended ad sizes: <strong>728x90</strong></div>
                </td>
            </tr>
            <tr valign="top">
                <th scope="row"><label for="middlelargeattachmentads">Middle Attachment Ads</label></th>
                <td>
                    <textarea cols="40" rows="6" name="middlelargeattachmentads" id="middlelargeattachmentads" /><?php echo stripslashes(get_option('business_middlelargeattachmentads')); ?></textarea>
                    <div style="font-size:11px;margin-top:6px;font-style:italic;">Recommended ad sizes: <strong>728x90</strong></div>
                </td>
            </tr>
<tr valign="top">
     <th scope="row"><label for="topheader">Matched Content</label></th>
         <td>
            <textarea cols="40" rows="6" name="matchedcontent"id="matchedcontent"/><?php echo stripslashes(get_option('business_matchedcontent')); ?></textarea>
            <div style="font-size:11px;margin-top:6px;font-style:italic;">Recommended ad sizes: responsive </div>
         </td>
 </tr>
            <tr valign="top">
                <th scope="row"><label for="header">Insert Header Script</label></th>
                <td>
                    <textarea cols="40" rows="6" name="headerscripts" id="headerscripts" /><?php echo stripslashes(get_option('business_headerscripts')); ?></textarea>
                    <div style="font-size:11px;margin-top:6px;font-style:italic;">This script will be placed in &lt;head&gt; or before &lt;/head&gt;</em>
                    </div>
                </td>
            </tr>
            <tr>
                <th><label for="analytics">Insert Footer Script</label></th>
                <td>
                    <textarea name="footerscripts" id="footerscripts" cols="40" rows="6"><?php echo stripslashes(get_option('business_footerscripts')); ?></textarea>
                    <div style="font-size:11px;margin-top:6px;font-style:italic;">Place your Statcounter/Histats/Google Analytics code here</div>
                </td>
            </tr>
        </table>
        <p class="submit">
            <input type="submit" name="Submit" class="button-primary" value="Save Changes" />
            <input type="hidden" name="business_settings" value="save" style="display:none;" />
        </p>
    </form>
    </p>
<?php } ?>