<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package aThemes
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>


         <?php if (is_attachment()) { ?>
            <title><?php echo ucwords(str_replace("-", " ", wp_title(' |', false, 'right'))); ?> <?php if (wp_title('', false)) {
            echo ':';
        } ?> <?php printf(__('%2$s', ''), esc_url(get_permalink($post->post_parent)), get_the_title($post->post_parent)); ?></title> 
        <?php } else { ?>
            <title><?php echo ucwords(str_replace("-", " ", wp_title(' |', true, 'right'))); ?></title>
        <?php }
        ?>


        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width">
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
        <?php if (get_theme_mod('site_favicon')) : ?>
            <link rel="shortcut icon" href="<?php echo esc_url(get_theme_mod('site_favicon')); ?>" />
        <?php endif; ?>
        <?php if (get_theme_mod('apple_touch_144')) : ?>
            <link rel="apple-touch-icon" sizes="144x144" href="<?php echo esc_url(get_theme_mod('apple_touch_144')); ?>" />
        <?php endif; ?>
        <?php if (get_theme_mod('apple_touch_114')) : ?>
            <link rel="apple-touch-icon" sizes="114x114" href="<?php echo esc_url(get_theme_mod('apple_touch_114')); ?>" />
        <?php endif; ?>
        <?php if (get_theme_mod('apple_touch_72')) : ?>
            <link rel="apple-touch-icon" sizes="72x72" href="<?php echo esc_url(get_theme_mod('apple_touch_72')); ?>" />
        <?php endif; ?>
        <?php if (get_theme_mod('apple_touch_57')) : ?>
            <link rel="apple-touch-icon" href="<?php echo esc_url(get_theme_mod('apple_touch_57')); ?>" />
        <?php endif; ?>	
        <?php
        if (get_option('business_headerscripts') != "") {
            if (get_option('business_headerscripts') <> "") {
                echo stripslashes(stripslashes(get_option('business_headerscripts')));
            }
        }
        ?>   
        <?php wp_head(); ?>
        <?php if (is_attachment()) {
            ?>
        <meta name="description" content="<?php
            $deattid = $post->ID;
            $dpost = get_post($deattid);
            $dtitle = $dpost->post_title;
            $dtitle = ucwords(str_replace("-", " ", $dtitle));
            $thumb_img = get_post(get_post_thumbnail_id());
            $thumb_img->post_excerpt;
            $dcontent = $dpost->post_content;
            $dcontent = ucfirst(strtolower($dcontent));
            $prid = $dpost->post_parent;
            $parr = get_post($prid);
            $prtitle = $parr->post_title;
            $posttags = get_the_tags($prid);
            $dtags = '';
            if ($posttags) {
                foreach ($posttags as $tag) {
                    $tagname = $tag->name;
                    $dtags .= $tagname . ',';
                }
            }
            $dtags .= ']';
            $detags = str_replace(',]', '', $dtags);
            $fullsize_image = wp_get_attachment_image_src($image['id'], 'full');
            $mtdesc = $prtitle . ', entitled as ' . $dtitle . ' - also describes ' . $thumb_img->post_excerpt . ' and labeled as: ' . $detags;
            echo 'This photo about: ';
            echo $mtdesc;
            echo ', with resolution ' . $fullsize_image[1] . 'px x ' . $fullsize_image[2] . 'px';
            ?>" />
                  <?php
              }
              ?>
		
	<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-8822023861660608"
     crossorigin="anonymous"></script>
    </head>
    <body <?php body_class(); ?>>

    <?php
    if (is_single() || is_attachment() ) {
        if (($ngopi_opt = get_option('business_topheader')) && !empty($ngopi_opt)) { ?>

            <div class="clearfix container">
                <div id="header-ads">
                    <?php echo stripslashes(stripslashes($ngopi_opt)); ?>
                </div>
            </div>
            <?php
        }
    }
    ?>

        <header id="masthead" class="site-header" role="banner">
            <div class="clearfix container">
                <div class="site-branding">
                    <?php if (get_theme_mod('site_logo')) : ?>
                        <a href="<?php echo esc_url(home_url('/')); ?>" title="<?php bloginfo('name'); ?>">
                            <img src="<?php echo esc_url(get_theme_mod('site_logo')); ?>" alt="<?php bloginfo('name'); ?>" />
                        </a>
                    <?php else : ?>			
                        <div id="logo">
                            <?php if (is_single() OR is_page()) { ?>
                                <h2 id="logo">
                                    <a href="<?php bloginfo('url'); ?>" title="<?php bloginfo('name'); ?>"><?php bloginfo('name'); ?></a>
                                </h2>
                            <?php } else {
                                ?>
                                <h1 id="logo">
                                    <a href="<?php bloginfo('url'); ?>" title="<?php bloginfo('description'); ?>"><?php bloginfo('name'); ?></a>
                                </h1>
                            <?php } ?>
                        </div>
                        <div class="site-description"><?php bloginfo('description'); ?></div>
                    <?php endif; ?>
                    <!-- .site-branding -->
                </div>
                <?php if (!dynamic_sidebar('sidebar-2')) : ?>
                <?php endif; ?>
                <nav id="main-navigation" class="main-navigation reset-nav" role="navigation">
                    <a href="#main-navigation" class="nav-open">Menu</a>
                    <a href="#" class="nav-close">Close</a>
                    <?php // wp_nav_menu(array('container_class' => 'clearfix sf-menu', 'theme_location' => 'main')); ?>
                    <div class="clearfix sf-menu">
                        <ul>
                            <?php
                            $args = array(
                                'hierarchical ' => 0
                            );
                            $cats = get_categories($args);
                            $i = 0;
                            foreach ($cats as $cat)
                                if ($i < 7) {
                                    $i +=1;
                                    echo '<li class="page_item"><a href="' . get_category_link($cat->term_id) . '">' . $cat->name . '</a></li>';
                                }
                            ?>
                            <li> <a href="#">All Categories &raquo; </a>
                                <ul>
                                    <?php
                                    $args = array(
                                        'hierarchical ' => 0
                                    );
                                    $cats = get_categories($args);
                                    foreach ($cats as $cat) {
                                        echo '<li class="page_item"><a href="' . get_category_link($cat->term_id) . '">' . $cat->name . '</a></li>';
                                    }
                                    ?>
                                </ul>
                            </li>
                        </ul>
                    </div>                     
                    <!-- #main-navigation -->
                </nav>
            </div>
            <!-- #masthead --></header>
        <div id="main" class="site-main">
            <div class="clearfix container">