<?php
/**
 * The template for displaying image attachments.
 *
 * @package aThemes
 */
get_header();
?>

<div id="primary" class="content-area image-attachment">
    <div id="content" class="site-content" role="main">

        <?php while (have_posts()) : the_post(); ?>

            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <header class="entry-header">
                    <?php the_title('<h1 class="entry-title heading-single">', '</h1>'); ?>


                    <!-- .entry-header -->
                </header>

                <?php if (get_option('business_toplargeattachmentads') != "") { ?>
                    <div class="TopAttachmentAds-728">
                        <?php
                        if (get_option('business_toplargeattachmentads') <> "") {
                            echo stripslashes(stripslashes(get_option('business_toplargeattachmentads')));
                        }
                        ?>
                    </div>
                <?php } ?> 

                <div class="entry-content">
                    <div class="entry-attachment">
                        <div class="attachment">
                            <?php athemes_the_attached_image(); ?>
                            <!-- .attachment -->
                        </div>

                        <?php if (has_excerpt()) : ?>

                            <?php the_excerpt(); ?>
                            <!-- .entry-caption -->
                        <?php endif; ?>
                        <!-- .entry-attachment -->
                    </div>

                    <?php if (get_option('business_middlelargeattachmentads') != "") { ?>
                        <div class="MiddleAttachmentAds-728">
                            <?php
                            if (get_option('business_middlelargeattachmentads') <> "") {
                                echo stripslashes(stripslashes(get_option('business_middlelargeattachmentads')));
                            }
                            ?>
                        </div>
                    <?php } ?>





                    <?php
                    the_content();
                    wp_link_pages(array(
                        'before' => '<div class="page-links">' . __('Pages:', 'athemes'),
                        'after' => '</div>',
                    ));
                    ?>
                    <!-- .entry-content -->




                    <div class="attachmenttext">
                        <div class="uplinkattachment" style="text-align:center;">
                <h2>
                    <span class='fa fa-photo'></span> Back to: 
                    <?php
                    printf(__('<a href="%1$s" title="Return to %2$s" rel="gallery"> %2$s </a>', 'tetapsemangat'), esc_url(get_permalink(
                                            $post->post_parent)), get_the_title($post->post_parent));
                    ?>
                </h2>
            </div>
                    </div>


                </div>




                <div class="clear"></div>   

                <nav role="navigation" id="image-navigation" class="image-navigation">
                    <div class="nav-previous"><?php previous_image_link(false, __('<span class="meta-nav"><i class="ico-left-open"></i></span> Previous', 'athemes')); ?></div>
                    <div class="nav-next"><?php next_image_link(false, __('Next <span class="meta-nav"><i class="ico-right-open"></i></span>', 'athemes')); ?></div>
                    <!-- #image-navigation -->
                </nav>

<?php if (get_option('business_medianet') != "") { ?>
        <div class="singleads">
            <?php
            if (get_option('business_medianet') <> "") {
                echo stripslashes(stripslashes(get_option('business_medianet')));
            }
            ?></div>
    <?php } ?>

                <footer class="entry-meta"> 
                    <div id="gallerysingle">
                        <?php gb(); ?>
                    </div>
                    <!-- .entry-meta -->
                    <?php if (get_option('business_middlesquareattachmentads') != "") { ?>
                        <div class="MiddleAttachmentAds-336">
                            <?php
                            if (get_option('business_middlesquareattachmentads') <> "") {
                                echo stripslashes(stripslashes(get_option('business_middlesquareattachmentads')));
                            }
                            ?>
                        </div>
                    <?php } ?>
                    <div class="clear"></div>
                </footer>

                <div class="relatedss">
                    <h3>Related Post from <?php the_title(); ?></h3>

                    <?php if ( is_single() OR is_attachment() ) { ?>
                        <?php if ( get_option( 'business_matchedcontent' ) != "" ) { ?>
                            <div id="matchedcontent-ads">
                                <?php
                                if ( get_option( 'business_matchedcontent' ) <> "" ) {
                                    echo stripslashes( stripslashes( get_option( 'business_matchedcontent' ) ) );
                                }
                                ?>
                            </div>
                        <?php } ?>
                    <?php } ?>

                    <ul>
                        <?php
                        $recent_posts = get_posts('numberposts=3&orderby=rand'); //angka 6 = jumlah postingan yang mau ditampilkan
                        foreach ($recent_posts as $post) :
                            setup_postdata($post);
                            $the_excerpt = substr( get_the_excerpt(), 0, 200 );
                            $the_excerpt = trim( preg_replace( '/\s+/', ' ', $the_excerpt ) );
                            ?>
                            <li class="clearfix">
                                <div class="widget-entry-thumbnail">
                                    <?php relateds(); ?>
                                </div>
                                <div class="widget-entry-summary">
                                    <h4><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a></h4>

                                    <p><?php echo $the_excerpt;?></p>

                                </div>
                                <div class="clear"></div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>

                <!-- #post-## --></article>            

        <?php endwhile; // end of the loop.    ?>

        <!-- #content --></div>
    <!-- #primary --></div>

<?php get_sidebar(); ?>
<?php get_footer(); ?>