<?php
/**
 * Template Name: Privacy Page
 *
 * This is the template that displays full width pages.
 * 
 * @package aThemes
 */
get_header();
?>
<div id="content" class="site-content-wide" role="main">
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
            <div class="post" id="post-<?php the_ID(); ?>">
                <div class="element-title"><h1 class="post-title">Privacy Policy</h1></div>
                <p><strong><?php bloginfo('url'); ?></strong> takes your privacy seriously. This privacy policy describes what personal information we collect and how we use it. See this <a href="http://en.wikipedia.org/wiki/Privacy_policy" target="_blank" rel="nofollow">privacy policy primer</a> to learn more about privacy policies in general.</p>
                <h2 class="post-title">Routine Information Collection</h2>
                <p>All web servers track basic information about their visitors. This information includes, but is not limited to, IP addresses, browser details, timestamps and referring pages. None of this information can personally identify specific visitors to this site. The information is tracked for routine administration and maintenance purposes.</p>
                <h2 class="post-title">Cookies and Web Beacons</h2>
                <p>Where necessary, <?php bloginfo('url'); ?> uses cookies to store information about a visitor's preferences and history in order to better serve the visitor and/or present the visitor with customized content.</p>
                <p>Advertising partners and other third parties may also use cookies, scripts and/or web beacons to track visitors to our site in order to display advertisements and other useful information. Such tracking is done directly by the third parties through their own servers and is subject to their own privacy policies.</p>
                <h2 class="post-title">Controlling Your Privacy</h2>
                <p>Note that you can change your browser settings to disable cookies if you have privacy concerns. Disabling cookies for all sites is not recommended as it may interfere with your use of some sites. The best option is to disable or enable cookies on a per-site basis. Consult your browser documentation for instructions on how to block cookies and other tracking mechanisms. This list of web browser privacy management links may also be useful.</p>
                <h2 class="post-title">Special Note About Google Advertising</h2>
                <p>Any advertisements served by Google, Inc., and affiliated companies may be controlled using cookies. These cookies allow Google to display ads based on your visits to this site and other sites that use Google advertising services. Learn how to <a href="http://www.google.com/privacy_ads.html"  target="_blank" rel="nofollow">opt out of Google's cookie usage</a>. As mentioned above, any tracking done by Google through cookies and other mechanisms is subject to Google's own privacy policies.</p>
                <h2 class="post-title">Contact Information</h2>
                <p>Concerns or questions about this privacy policy can be directed to admin@<?php bloginfo('url'); ?> for further clarification.</p>
                <div style="clear:both;"></div>
            </div>
        <?php
        endwhile;
    endif;
    ?>
    <!-- #content -->
</div>
<?php get_footer(); ?>