<?php
/**
 * Template Name: Sitemap Page
 *
 * This is the template that displays full width pages.
 * 
 * @package aThemes
 */
get_header();
?>
<div id="content" class="site-content-wide" role="main">
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
            <div class="post" id="post-<?php the_ID(); ?>">
                <h2 class="post-title"><?php the_title(); ?></h2>
                <h3 class="post-title">All Posts</h3>
                <div class="sitemapallpost">
                    <?php
                    $recent_posts = get_posts('numberposts=999&orderby=title&order=asc&posts_per_page=-1'); //angka 6 = jumlah postingan yang mau ditampilkan
                    foreach ($recent_posts as $post) :
                        setup_postdata($post);
                        ?>
                        <a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><h4><?php the_title(); ?></h4></a>
                        <?php
                        $args = array(
                            'post_type' => 'attachment',
                            'numberposts' => -1,
                            "orderby" => "rand",
                            "order" => "rand",
                            'post_status' => null,
                            'post_parent' => $post->ID
                        );
                        $attachments = get_posts($args);
                        if ($attachments) {
                            echo "<ul id='double'>";
                            foreach ($attachments as $attachment) {
                                echo '<li>';
                                $attachment_page = get_attachment_link($attachment->ID);
                                ?>
                                <a href="<?php echo $attachment_page; ?>" title="<?php echo get_the_title($attachment->ID); ?>"><?php echo get_the_title($attachment->ID); ?></a>
                                <?php
                                echo '</li>';
                            }
                            echo "</ul>";
                        }
                        ?>
                    <?php endforeach; ?>
                </div>
                <h3 class="post-title">All Categories</h3>
                <ul>
                    <?php wp_list_cats('optioncount=1'); ?>
                </ul>
                <h3 class="post-title">All Tags</h3>
                <p><?php wp_tag_cloud(); ?></p>
                <?php wp_link_pages(array('before' => '<p><strong>Pages:</strong> ', 'after' => '</p>', 'next_or_number' => 'number')); ?>
            </div>
        <?php
        endwhile;
    endif;
    ?>
    <!-- #content -->
</div>
<?php get_footer(); ?>