<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package aThemes
 */
?>

<div id="widget-area-2" class="site-sidebar widget-area" role="complementary">
    <aside id="athemes_tabs-1" class="widget widget_athemes_tabs">
        <ul id="widget-tab" class="clearfix widget-tab-nav">
            <li class="active"><a href="#widget-tab-popular">Inspiration</a></li>            
        </ul>

        <div class="widget-tab-content">
            <div class="tab-pane active" id="widget-tab-popular">
                <ul>
                    <?php
                    $recent_posts = get_posts('numberposts=5&orderby=rand'); //angka 6 = jumlah postingan yang mau ditampilkan
                    foreach ($recent_posts as $post) :
                        setup_postdata($post);
                        ?>
                        <li class="clearfix">
                            <div class="widget-entry-thumbnail">
                                <?php relateds(); ?> 
                            </div>
                            <div class="widget-entry-summary">
                                <h4><span class="fa fa-camera"></span> <a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a></h4>
                                <span>
                                    <?php
                                    /* translators: used between list items, there is a space after the comma */
                                    $category_list = get_the_category_list(__(', ', 'athemes'));
                                    printf($category_list);
                                    ?>
                                </span>
                            </div>
                        </li>
                    <?php endforeach; ?>
                </ul>
                <!-- #widget-tab-popular -->
            </div>


        </div>
    </aside><!-- #widget-area-1 -->

    <aside id="athemes_tabs-2" class="widget widget_athemes_tabs">       
        <div class="widget-tab-content">
            <div class="tab-pane active" id="widget-tab-popular">
                <?php
                $recent_posts = get_posts('numberposts=12&orderby=rand');
                foreach ($recent_posts as $post) :
                    setup_postdata($post);
                    ?>
                    <div class="widget-gallery">
                        <?php relateds(); ?>
                    </div>
                <?php endforeach; ?>
                <div class="clearfix"></div>
            </div>
        </div>
    </aside>

    <?php if (!dynamic_sidebar('sidebar-1')) : ?>
    <?php endif; ?>
    <!-- #widget-area-2 -->
</div>