<?php
// Template Name: BZ Contact Page
/**
 *
 * @package progression
 * @since progression 1.0
 */
$nameError = '';
$emailError = '';
$commentError = '';
$sumError = '';
if (isset($_POST['submitted'])) {
    if (trim($_POST['contactName']) === '') {
        $nameError = 'Please enter your name.';
        $hasError = true;
    } else {
        $name = trim($_POST['contactName']);
    }
    if (trim($_POST['email']) === '') {
        $emailError = 'Please enter your email address.';
        $hasError = true;
    } else if (!eregi("^[A-Z0-9._%-]+@[A-Z0-9._%-]+\.[A-Z]{2,4}$", trim($_POST['email']))) {
        $emailError = 'You entered an invalid email address.';
        $hasError = true;
    } else {
        $email = trim($_POST['email']);
    }
    if (trim($_POST['comments']) === '') {
        $commentError = 'Please enter a message.';
        $hasError = true;
    } else {
        if (function_exists('stripslashes')) {
            $comments = stripslashes(trim($_POST['comments']));
        } else {
            $comments = trim($_POST['comments']);
        }
    }
    if (trim($_POST['sum']) === '' || trim($_POST['sum']) != '17') {
        $sumError = "Please enter what's S E V E N + T E N";
        $hasError = true;
    }
    if (!isset($hasError)) {
        $emailTo = get_option('admin_email');
        if (!isset($emailTo) || ($emailTo == '')) {
            $emailTo = get_option('admin_email');
        }
        $subject = '[Contact Form] From ' . $name . ' in ' . get_bloginfo('name');
        $body = "Name: $name \n\nEmail: $email \n\nComments: $comments";
        $headers = 'From: ' . $name . ' <' . $email . '>' . "\r\n" . 'Reply-To: ' . $email;
        wp_mail($emailTo, $subject, $body, $headers);
        $emailSent = true;
    }
}
?> 
<?php get_header();
?>


<?php while (have_posts()) : the_post(); ?>
    <div id="content-container">	
        <div class="element-title"><h1 class="solar-post-headline"><?php the_title(); ?></h1></div>
        <div class="contact-form clearfix">
    <?php if (isset($emailSent) && $emailSent == true) { ?>
                <div class="thanks">
                    <p><?php _e('Thanks, your email was sent successfully.', 'framework') ?></p>
                </div>
    <?php } else { ?>
                <?php the_content(); ?>
                <?php if (isset($hasError) || isset($captchaError)) { ?>
                    <p class="error"><?php _e('Sorry, an error occured.', 'framework') ?><p>
                <?php } ?>
                <form action="<?php the_permalink(); ?>" id="contactForm" method="post">
                    <div class="contactform">
                        <div><span style="width:60px; display:block"><label for="contactName"><?php _e('Name:', 'framework') ?></label></span>
                            <input type="text" name="contactName" id="contactName" value="<?php if (isset($_POST['contactName'])) echo $_POST['contactName']; ?>" class="required requiredField" />
        <?php if ($nameError != '') { ?>
                                <span class="error"><?php echo $nameError; ?></span> 
                            <?php } ?>
                        </div>
                        <div><span style="width:60px; display:block"><label for="email"><?php _e('Email:', 'framework') ?></label></span>
                            <input type="text" name="email" id="email" value="<?php if (isset($_POST['email'])) echo $_POST['email']; ?>" class="required requiredField email" />
        <?php if ($emailError != '') { ?>
                                <span class="error"><?php echo $emailError; ?></span>
                            <?php } ?>
                        </div>
                        <div class="textarea"><span style="width:60px; display:block"><label for="commentsText"><?php _e('Message:', 'framework') ?></label></span>
                            <textarea name="comments" id="commentsText" rows="15" cols="64" class="required requiredField"><?php
                    if (isset($_POST['comments'])) {
                        if (function_exists('stripslashes')) {
                            echo stripslashes($_POST['comments']);
                        } else {
                            echo $_POST['comments'];
                        }
                    }
                            ?></textarea>
                                <?php if ($commentError != '') { ?>
                                <span class="error"><?php echo $commentError; ?></span> 
                            <?php } ?>
                        </div>
                        <div><br /><span style="width:60px;"><label for="sum"><?php _e('7 + 3 + 7 = ', 'framework') ?></label></span>
                            <input type="text" name="sum" id="sum" value="<?php if (isset($_POST['sum'])) echo $_POST['sum']; ?>" class="required requiredField" />
        <?php if ($sumError != '') { ?>
                                <br/><span class="error"><?php echo $sumError; ?></span> 
                            <?php } ?>
                        </div>
                        <div class="buttons"><br />
                            <input type="hidden" name="submitted" id="submitted" value="true" />
                            <label></label><button class="button-message" type="submit"><?php _e('Send Email', 'framework') ?></button>
                        </div>
                    </div>
                </form>
    <?php } ?>
        </div>
        <div class="clearfix">

        </div>	
    </div><!-- close #content-container -->			
<?php endwhile; // end of the loop.  ?>
<div id="sidebar">
	<?php if ( ! dynamic_sidebar( 'homepage-sidebar' ) ) : ?><?php endif; // end sidebar widget area ?>
<div class="clearfix"></div>
</div>
<?php get_footer(); ?>